require( "scripts/style.lua" );


MyFont = {
  standardFont,
  30,
  BlackColor
};

MyFont2 = {
  standardFont,
  20,
  BlackColor
};

NameFont = {
  standardFont,
  20,
  BlackColor
};

local playername = gEnterNameValue;
local deleteselected = false;

if not playername or playername=="" then
	deleteselected = true;
	playername = GetString("enternameprompt") ;
end


DLGSPEC = 
{
		image = "backgrounds/largedialog",
		mask = exists("backgrounds/largedialog.mask.png");
		x=kCenter+5,
		y=kCenter-5,
		
		Text
		{
			font = MyFont2,
			name = "enternamewelcome",
			x=0,y=80,w=kMax,h=30,
			flags = kHAlignCenter + kVAlignTop,
			label = "enternamewelcome"
		};
		
		Text
		{
			font = MyFont,
			name = "entername",
			x=0,y=120,w=kMax,h=30,
			flags = kHAlignCenter + kVAlignTop,
			label = "entername"
		};
		
		Bitmap
		{
			image = "backgrounds/textfield",
			x=kCenter,
			y=200,
			
			TextEdit
			{
				font = NameFont,
				name = "nameedit",
				label = playername,
				enablewindow = "enterok",
				utf8=true,
				clearinitial = deleteselected,
				x=0,y=5,w=kMax,h=kMax,
				length=20,
				ignore = kIllegalNameChars,
				flags = kHAlignCenter + kVAlignCenter,
				
			};
		};
			
		Button
		{
			x=kCenter-70,
			y=-130,
			font = ThinButtonFont,
			graphics = ThinButtonGraphics,
			name="enterok",
			label="ok",
			type = kPush,
			default=true,	-- Make this the default button
			command =
				function()
					local newname = GetLabel("nameedit");
					-- crop leading and trailing spaces
					newname = string.gsub( newname, "^%s+", "" );
					newname = string.gsub( newname, "%s+$", "" );
					if (string.len( newname )==0 ) then
						DisplayDialog {
							"scripts/ok.lua",
							body ="pleaseenteraname",
							title = ""
						};
						SetFocus( "nameedit" )
					elseif (newname ~= playername and IsNameInUse(newname)) then
						DisplayDialog { 
							"scripts/ok.lua", 
							body ="nameinuse",
							title = ""
						};
						SetFocus( "nameedit" )
					else
						ModalReturn(GetLabel("nameedit"));
						StartClose();
					end
				end
		},
		
		Button
		{
			x = kCenter+70,
			y = -130,
			font = ThinButtonFont,
			graphics = ThinButtonGraphics,
			name="entercancel",
			label="cancel",
			type = kPush,
			command = function()
				-- CloseWindow(nil);
				ModalReturn(nil);
				StartClose();
			end
		};
	};
	
MakeDialog
{
	tTransitionWindow
	{
		x = 0, y = 0, w = kMax, h = kMax, 
		speed_in = slide_speed_in, speed_out = slide_speed_out, accel_in = slice_accel_in, accel_out = slide_accel_out,
		Bitmap(DLGSPEC),
	}
};


SetFocus( "nameedit" );

if (deleteselected) then
	EnableWindow("enterok", false);
end


